package GUI;


import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import baseClass.Recomendacoes;

/**
 * @author Carlos Victor 
 */
public class JanelaComparacao implements MouseListener, ActionListener {

	private JFrame window = null;
	private JPanel panel1 = null;
	private JButton button1,button2,button3= null;
	private JLabel label1,label2,label4= null;
	private JTextField textFieldNumItens = null;
	private Recomendacoes recomendacoes = null;
	private JLabel label3 = null;
	private JLabel label6 = null;
	private JTextArea txt = null;
	private JTextArea txt2 = null;
	private JScrollPane comp = null; 
	private JScrollPane comp2 = null; 

	
	/**
	 * Cria uma nova janela de sistema de recomendacoes
	 * @param opinioes
	 * 		O caminho do arquivo de opinioes.
	 * @param enderecos
	 * 		O caminho do arquivo de enderecos.
	 */
	public JanelaComparacao(Recomendacoes recomendacoes) {
		
		this.recomendacoes = recomendacoes;
		
		createWindow();
	}

	/**
	 * Criacao da janela.
	 */
	private void createWindow() {
		window = new JFrame();
		panel1 = new JPanel();
		button1 = new JButton("ok");
		button2 = new JButton("Voltar");
		button3 = new JButton("Ajuda");
		label1 = new JLabel("COMPARAÇÃO DE ALGORITMOS.");
		label3 = new JLabel("DIGITE O NÚMERO DE ITENS A SER COMPARADO.");
		label4 = new JLabel("PERCENTUAL GLOBAL"); 
		label2 = new JLabel("PERCENTUAL PERSONALIZADO."); 
		label6 = new JLabel(); 
		txt = new JTextArea();
		txt2 = new JTextArea();
		textFieldNumItens = new JTextField(15);
		comp = new JScrollPane(txt);
		comp2 = new JScrollPane(txt2);
		
		window.setSize(700, 600);
		window.setResizable(true);
		window.setMinimumSize(new Dimension(300, 200));
		window.setLocation(280, 60);
		window.setVisible(true);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		
		label6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v3.png")));
		label6.setLocation(0, -150);
		label6.setSize(550,470);
		label1.setLocation(380, -100);
		label1.setSize(300, 300);
		label1.setForeground(Color.WHITE);
		label3.setLocation(30, -10);
		label3.setSize(650, 580);
		label3.setForeground(Color.WHITE);
		label2.setLocation(400, -30);
		label2.setSize(650, 580);
		label2.setForeground(Color.WHITE);
		label4.setLocation(430, 120);
		label4.setSize(650, 580);
		label4.setForeground(Color.WHITE);
		
		
		panel1.setVisible(true);
		panel1.setLayout(null);
		panel1.setBackground(Color.ORANGE);
			
		
		button1.setToolTipText("Carrega recomendações");
		button1.setEnabled(true);
		button1.addMouseListener(this);
		button1.addActionListener(this);
		button1.setLocation(110,390);
		button1.setSize(80,30);
		button1.setForeground(Color.ORANGE);
		button2.setToolTipText("Voltar ao menu principal");
		button2.setEnabled(true);
		button2.addMouseListener(this);
		button2.addActionListener(this);
		button2.setSize(80,30);
		button2.setLocation(110, 460);
		button2.setForeground(Color.ORANGE);
		button3.setToolTipText("Voltar ao menu principal");
		button3.setEnabled(true);
		button3.addMouseListener(this);
		button3.addActionListener(this);
		button3.setSize(80,30);
		button3.setLocation(450, 80);
		button3.setForeground(Color.ORANGE);
		
		
		comp.setSize(300, 100);
		comp.setLocation(350, 270);
		comp2.setSize(300, 100);
		comp2.setLocation(350, 420);
		txt.setEnabled(false);
		txt2.setEnabled(false);
		
		
		textFieldNumItens.addMouseListener(this);
		textFieldNumItens.setEnabled(true);
		textFieldNumItens.setSize(40, 30);
		textFieldNumItens.setLocation(130, 305);
		
		
		panel1.add(label1);
		panel1.add(label2);
		panel1.add(label3);
		panel1.add(label4);
		panel1.add(label6);
		panel1.add(comp);
		panel1.add(comp2);
		panel1.add(button1);
		panel1.add(button2);
		panel1.add(button3);
		panel1.add(textFieldNumItens);
		
		window.add(panel1);
	}

	/**
	 * M�todos referentes ao MouseListenner
	 */
	public void mouseClicked(MouseEvent arg0) {
	}

	public void mouseEntered(MouseEvent arg0) {
	}
	
	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

	/**
	 * Metodo referente ao ActionListener
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == button1) {
			txt.setText("");
			txt2.setText("");
			int numItens = 1;
			if (textFieldNumItens.getText().isEmpty()) {
				JOptionPane.showMessageDialog(null, "Digite o número de itens a ser comparado");
			}else{
				try{
					numItens = Integer.parseInt(textFieldNumItens.getText());
					
					if (numItens < 1) {
						numItens = 1;
					}
					try {
						String[] percents = recomendacoes.comparaAlgoritmos(numItens).split("\n");
						txt.append(percents[0]);
						txt2.append(percents[1]);
					} catch (Exception e1) {
						JOptionPane.showMessageDialog(null, "Número de restaurantes excedido");
					}
				}catch (Exception ex){
					JOptionPane.showMessageDialog(null, "Digite apenas números!");
				}
			}
		}
		
		if (e.getSource() == button2) {
			window.dispose();
			new MenuRecomendacoes(recomendacoes.getCaminhoArquivo2(), recomendacoes.getCaminhoArquivo1());
		}
		
		if (e.getSource() == button3) {
			JOptionPane.showMessageDialog(null, "COMPARAÇÃO DE ALGORITMOS\nDIGITE O NÚMERO DE ITENS E PRESSIONE OK PARA VERIFICAR O INDICE DE ACERTO ENTRE O ALGORITMO PERSONALIZADO E O GLOBAL.");
		}
	}
}
